﻿//////////////////////////////////////////////
// SamplerManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "Sampler.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT SamplerManager final : public Manager<Sampler>, public nkCommon::MaybeSingletonClass<SamplerManager>
	{
		public :

			// Available default resource names
			inline static const nkMemory::StringView DEFAULT_SAMPLER = "NILKINS_DEFAULT_SAMPLER" ;

		private :

			// Constructors
			SamplerManager (bool isSingleton) noexcept ;
			SamplerManager (System* system) noexcept ;
		
		private :

			friend class nkCommon::MaybeSingletonClass<SamplerManager> ;
			friend class System ;
	} ;
}